using System;
using System.Threading;
using System.Runtime.InteropServices;
using System.Collections.Generic;
using System.Text;

namespace PInvoke2
{
   class Program
   {
      [DllImport("kernel32.dll")]
      static extern IntPtr LoadLibrary(string dllName);

      [DllImport("kernel32.dll")]
      static extern IntPtr GetProcAddress(IntPtr hModule, string procName);

      delegate int MessageBoxDelegate(IntPtr hwnd,
         [MarshalAs(UnmanagedType.LPWStr)]string text,
      [MarshalAs(UnmanagedType.LPWStr)]string caption,
         int type);

      static void Main(string[] args)
      {
         IntPtr userApi = LoadLibrary("user32.dll");
         IntPtr msgBoxAddress = GetProcAddress(userApi,
            "MessageBoxW"); // okno komunikatw w standardzie Unicode (wide)
         MessageBoxDelegate mbd = (MessageBoxDelegate)
            Marshal.GetDelegateForFunctionPointer(msgBoxAddress,
            typeof(MessageBoxDelegate));
         mbd(IntPtr.Zero, "Pozdrowienia od Platform Invoke", "Platform Invoke", 0);

         DoSomething(mbd);
      }

      static void DoSomething(MessageBoxDelegate mbd)
      {
         Thread.Sleep(200);
         mbd(IntPtr.Zero, "Zadanie ukoczone.", "Postp w Wykonywaniu Zadania", 0);
      }
   }
}
